/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsClient;
import com.ibm.hsc.filesvr.FsConnectionCloseRequestPacket;
import com.ibm.hsc.filesvr.FsConnectionCloseResponsePacket;
import com.ibm.hsc.filesvr.FsConnectionInfoRequestPacket;
import com.ibm.hsc.filesvr.FsConnectionInfoResponsePacket;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileCloseRequestPacket;
import com.ibm.hsc.filesvr.FsFileCloseResponsePacket;
import com.ibm.hsc.filesvr.FsFileDescriptor;
import com.ibm.hsc.filesvr.FsFileFilter;
import com.ibm.hsc.filesvr.FsFileListRequestPacket;
import com.ibm.hsc.filesvr.FsFileListResponsePacket;
import com.ibm.hsc.filesvr.FsFileOpenRequestPacket;
import com.ibm.hsc.filesvr.FsFileOpenResponsePacket;
import com.ibm.hsc.filesvr.FsFileReadRequestPacket;
import com.ibm.hsc.filesvr.FsFileReadResponsePacket;
import com.ibm.hsc.filesvr.FsMessagePacket;
import com.ibm.hsc.filesvr.FsPacket;
import com.ibm.hsc.filesvr.FsSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class FsConnection
extends Thread {
    protected static final long DEFAULT_SLEEP_TIME_MILLISECONDS = 500L;
    public static final int PLATFORM_DUMP_FILE = 1;
    private Socket m_socket;
    private BufferedInputStream m_inputStream;
    private BufferedOutputStream m_outputStream;
    private boolean m_open = true;
    private Hashtable m_fileListHash = new Hashtable();
    private FsFileFilter m_filter = null;
    private Hashtable m_fileOpenHash = new Hashtable();
    private byte m_fileHandleCount = 0;

    public FsConnection(Socket socket) throws FsException {
        try {
            this.m_socket = socket;
            this.m_inputStream = new BufferedInputStream(this.m_socket.getInputStream());
            this.m_outputStream = new BufferedOutputStream(this.m_socket.getOutputStream());
            this.m_socket.setTcpNoDelay(true);
            this.m_socket.setSoLinger(false, 0);
            this.m_socket.setSoTimeout(50);
        }
        catch (Exception exception) {
            throw new FsException(512);
        }
    }

    protected void buildFileList(FsFileFilter fsFileFilter) throws FsException {
        if (fsFileFilter == null) {
            throw new FsException(23);
        }
        if (fsFileFilter.equals(this.m_filter)) {
            return;
        }
        this.m_fileListHash.clear();
        Vector<File> vector = new Vector<File>();
        File[] fileArray = null;
        File file = null;
        boolean bl = false;
        boolean bl2 = false;
        if (fsFileFilter.getType() == 1) {
            bl = FsSystem.recursePlatformDumpSubdirectories();
            bl2 = FsSystem.updatePlatformDumpFileName();
            vector.add(new File(FsSystem.getPlatformDumpFilePath()));
        } else {
            throw new FsException(23, fsFileFilter.getType());
        }
        while (!vector.isEmpty()) {
            File file2 = (File)vector.get(0);
            vector.remove(0);
            fileArray = file2.listFiles();
            if (fileArray == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                File file3;
                file = fileArray[i];
                if (file.isDirectory()) {
                    if (!bl) continue;
                    vector.add(file);
                    continue;
                }
                FsFileDescriptor fsFileDescriptor = new FsFileDescriptor(file);
                if (bl2 && fsFileDescriptor.getName().equals("DumpFile") && (file3 = file.getParentFile()) != null) {
                    String string = file3.getName().toUpperCase();
                    try {
                        FileReader fileReader = new FileReader(file);
                        fileReader.skip(24L);
                        char[] cArray = new char[40];
                        fileReader.read(cArray);
                        fileReader.close();
                        String string2 = new String(cArray);
                        int n = string2.indexOf(0);
                        if (0 < n) {
                            string2 = string2.substring(0, n);
                        }
                        int n2 = 0;
                        int n3 = string.length();
                        int n4 = 8;
                        while (n4 < 15) {
                            cArray[n4] = n3 > 0 ? string.charAt(n2) : (char)95;
                            ++n4;
                            ++n2;
                            --n3;
                        }
                        if (string2.substring(25, 29).compareTo("2003") < 0) {
                            int n5 = fsFileDescriptor.getDateYear() / 100;
                            cArray[25] = (char)(n5 / 10 + 48);
                            cArray[26] = (char)(n5 % 10 + 48);
                            n5 = fsFileDescriptor.getDateYear() % 100;
                            cArray[27] = (char)(n5 / 10 + 48);
                            cArray[28] = (char)(n5 % 10 + 48);
                            n5 = fsFileDescriptor.getDateMonth();
                            cArray[29] = (char)(n5 / 10 + 48);
                            cArray[30] = (char)(n5 % 10 + 48);
                            n5 = fsFileDescriptor.getDateDay();
                            cArray[31] = (char)(n5 / 10 + 48);
                            cArray[32] = (char)(n5 % 10 + 48);
                            n5 = fsFileDescriptor.getDateHour();
                            cArray[33] = (char)(n5 / 10 + 48);
                            cArray[34] = (char)(n5 % 10 + 48);
                            n5 = fsFileDescriptor.getDateMinute();
                            cArray[35] = (char)(n5 / 10 + 48);
                            cArray[36] = (char)(n5 % 10 + 48);
                            n5 = fsFileDescriptor.getDateSecond();
                            cArray[37] = (char)(n5 / 10 + 48);
                            cArray[38] = (char)(n5 % 10 + 48);
                        }
                        String string3 = new String(cArray, 0, string2.length());
                        fsFileDescriptor.setName(string3);
                        if (!string3.equals(string2)) {
                            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                            randomAccessFile.seek(24L);
                            randomAccessFile.writeBytes(string3);
                            randomAccessFile.close();
                        }
                    }
                    catch (Exception exception) {
                        this.trace("FsConnection.buildFileList: Exception caught", exception);
                    }
                }
                if (fsFileFilter != null && !fsFileFilter.match(fsFileDescriptor)) continue;
                this.m_fileListHash.put(fsFileDescriptor.getName(), fsFileDescriptor);
            }
        }
        if (this.m_fileListHash.size() > 0) {
            this.m_filter = fsFileFilter;
            this.traceFileList("List of files being returned", this.m_fileListHash);
        }
    }

    public void close() {
        try {
            this.m_inputStream.close();
            this.m_outputStream.close();
            this.m_socket.close();
            this.m_open = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeFile(long l) {
        RandomAccessFile randomAccessFile = this.getOpenFile(l);
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_fileOpenHash.remove(new Long(l));
        }
    }

    public Hashtable getFileList(FsFileFilter fsFileFilter) throws FsException {
        this.buildFileList(fsFileFilter);
        return this.m_fileListHash;
    }

    public RandomAccessFile getOpenFile(long l) {
        return (RandomAccessFile)this.m_fileOpenHash.get(new Long(l));
    }

    public int getSocketId() {
        if (this instanceof FsClient) {
            return this.m_socket.getLocalPort();
        }
        return this.m_socket.getPort();
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public long openFile(int n, String string, boolean bl) throws FsException {
        try {
            Object object;
            FsFileDescriptor fsFileDescriptor = null;
            if (this.m_filter != null && n == this.m_filter.getType()) {
                fsFileDescriptor = (FsFileDescriptor)this.m_fileListHash.get(string);
            }
            if (fsFileDescriptor == null) {
                object = new FsFileFilter();
                ((FsFileFilter)object).setType(n);
                this.buildFileList((FsFileFilter)object);
                fsFileDescriptor = (FsFileDescriptor)this.m_fileListHash.get(string);
            }
            if (fsFileDescriptor == null) {
                throw new FsException(256, (long)n, (Object)string);
            }
            object = bl ? "r" : "rw";
            RandomAccessFile randomAccessFile = new RandomAccessFile(fsFileDescriptor.getFile(), (String)object);
            long l = (new Date().getTime() << 8) + (long)this.m_fileHandleCount;
            this.m_fileHandleCount = (byte)(this.m_fileHandleCount + 1);
            this.m_fileOpenHash.put(new Long(l), randomAccessFile);
            return l;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FsException(256, (long)n, (Object)string);
        }
    }

    public void readBytes(byte[] byArray) throws FsException {
        this.readBytes(byArray, 0, byArray.length);
    }

    public void readBytes(byte[] byArray, int n, int n2) throws FsException {
        int n3 = n2;
        try {
            int n4 = 0;
            while (n2 > 0) {
                try {
                    n4 = this.m_inputStream.read(byArray, n, n2);
                    if (n4 == -1) {
                        throw new SocketException();
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    n4 = 0;
                }
                if (n4 > 0) {
                    n2 -= n4;
                    n += n4;
                    continue;
                }
                this.sleep();
            }
        }
        catch (SocketException socketException) {
            this.close();
            throw new FsException(513, (Object)socketException);
        }
        catch (IOException iOException) {
            throw new FsException(768, (Object)iOException);
        }
        this.trace("FsConnection.readBytes: read " + n3 + " bytes");
    }

    public FsPacket readPacket() throws FsException {
        Object object;
        Object object2 = null;
        int n = FsPacket.getMinimumLength();
        byte[] byArray = new byte[n];
        this.readBytes(byArray);
        this.trace("FsConnection.readPacket: header bytes read");
        FsPacket fsPacket = new FsPacket(this);
        FsByteStream fsByteStream = new FsByteStream(byArray);
        FsPacket fsPacket2 = fsPacket.parse(fsByteStream);
        if (fsPacket2 != null) {
            this.trace("FsConnection.readPacket: error parsing header, flushing input stream", fsByteStream);
            try {
                int n2 = this.m_inputStream.available();
                while (n2 > 0) {
                    this.trace("FsConnection.readPacket: Skipping" + n2 + " bytes");
                    this.m_inputStream.skip(n2);
                    n2 = this.m_inputStream.available();
                }
            }
            catch (IOException iOException) {
                this.trace("FsConnection.readPacket: I/O exception while flushing input stream");
            }
            if (fsPacket2.getReturnCode() == 16 || fsPacket2.getReturnCode() == 17) {
                return null;
            }
            return fsPacket2;
        }
        int n3 = fsPacket.getLength();
        this.trace("FsConnection.readPacket: packet header valid, length is " + fsPacket.getLength() + ", op code is " + fsPacket.getOpCode());
        if (n3 > n) {
            object = byArray;
            byArray = new byte[n3];
            System.arraycopy(object, 0, byArray, 0, n);
            this.readBytes(byArray, n, n3 - n);
            fsByteStream = new FsByteStream(byArray);
        } else {
            fsByteStream.reset();
        }
        switch (fsPacket.getOpCode()) {
            case 0: {
                object2 = new FsPacket(this);
                break;
            }
            case 1: {
                this.trace("FsConnection.readPacket: message packet being processed", fsByteStream);
                object2 = new FsMessagePacket(this);
                break;
            }
            case 2: {
                if (fsPacket.isRequestPacket()) {
                    this.trace("FsConnection.readPacket: connection info request packet being processed", fsByteStream);
                    object2 = new FsConnectionInfoRequestPacket(this);
                    break;
                }
                this.trace("FsConnection.readPacket: connection info response packet being processed", fsByteStream);
                object2 = new FsConnectionInfoResponsePacket(this);
                break;
            }
            case 3: {
                if (fsPacket.isRequestPacket()) {
                    this.trace("FsConnection.readPacket: connection close request packet being processed", fsByteStream);
                    object2 = new FsConnectionCloseRequestPacket(this);
                    break;
                }
                this.trace("FsConnection.readPacket: connection close response packet being processed", fsByteStream);
                object2 = new FsConnectionCloseResponsePacket(this);
                break;
            }
            case 4: {
                if (fsPacket.isRequestPacket()) {
                    this.trace("FsConnection.readPacket: file list request packet being processed", fsByteStream);
                    object2 = new FsFileListRequestPacket(this);
                    break;
                }
                this.trace("FsConnection.readPacket: file list response packet being processed", fsByteStream);
                object2 = new FsFileListResponsePacket(this);
                break;
            }
            case 5: {
                if (fsPacket.isRequestPacket()) {
                    this.trace("FsConnection.readPacket: file open request packet being processed", fsByteStream);
                    object2 = new FsFileOpenRequestPacket(this);
                    break;
                }
                this.trace("FsConnection.readPacket: file open response packet being processed", fsByteStream);
                object2 = new FsFileOpenResponsePacket(this);
                break;
            }
            case 6: {
                if (fsPacket.isRequestPacket()) {
                    this.trace("FsConnection.readPacket: file close request packet being processed", fsByteStream);
                    object2 = new FsFileCloseRequestPacket(this);
                    break;
                }
                this.trace("FsConnection.readPacket: file close response packet being processed", fsByteStream);
                object2 = new FsFileCloseResponsePacket(this);
                break;
            }
            case 7: {
                if (fsPacket.isRequestPacket()) {
                    this.trace("FsConnection.readPacket: file read request packet being processed", fsByteStream);
                    object2 = new FsFileReadRequestPacket(this);
                    break;
                }
                this.trace("FsConnection.readPacket: file read response packet being processed", fsByteStream);
                object2 = new FsFileReadResponsePacket(this);
                break;
            }
            default: {
                throw new FsException(19, fsPacket.getOpCode());
            }
        }
        if (object2 != null && (object = (Object)((FsPacket)object2).parse(fsByteStream)) != null) {
            this.trace("FsConnection.readPacket: parse error");
            object2 = object;
        }
        return object2;
    }

    public void setOpen(boolean bl) {
        this.m_open = bl;
    }

    public void sleep() {
        try {
            FsConnection.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void trace(String string) {
        this.trace(string, null);
    }

    public synchronized void trace(String string, Object object) {
        if (!FsSystem.isTraceOn()) {
            return;
        }
        System.out.println("Socket ID: " + this.getSocketId() + " at " + DateFormat.getDateTimeInstance(3, 2).format(new Date()) + ": " + string);
        if (object != null) {
            if (object instanceof FsByteStream) {
                ((FsByteStream)object).print();
            } else if (object instanceof Exception) {
                ((Exception)object).printStackTrace();
            } else {
                System.out.println(object.toString());
            }
        }
    }

    public void traceFileList(String string, Map map) {
        if (!FsSystem.isTraceOn()) {
            return;
        }
        String string2 = new String();
        if (map.size() > 0) {
            string2 = string2 + "     +-----------------------------------------------+------------+-----------------------+\n";
            string2 = string2 + "     | File Name                                     | File Size  | File Date             |\n";
            string2 = string2 + "     +-----------------------------------------------+------------+-----------------------+\n";
            Iterator iterator = map.keySet().iterator();
            try {
                while (iterator.hasNext()) {
                    FsFileDescriptor fsFileDescriptor = (FsFileDescriptor)map.get(iterator.next());
                    String string3 = fsFileDescriptor.getName();
                    while (string3.length() < 45) {
                        string3 = string3 + " ";
                    }
                    String string4 = Long.toString(fsFileDescriptor.getSize());
                    while (string4.length() < 10) {
                        string4 = " " + string4;
                    }
                    String string5 = fsFileDescriptor.getDateString();
                    while (string5.length() < 21) {
                        string5 = " " + string5;
                    }
                    string2 = string2 + "     | " + string3 + " | " + string4 + " | " + string5 + " |\n";
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            string2 = string2 + "     +-----------------------------------------------+------------+-----------------------+\n";
        } else {
            string2 = string2 + "     No files listed!";
        }
        this.trace(string, string2);
    }

    public void writeBytes(byte[] byArray) throws FsException {
        try {
            this.m_outputStream.write(byArray);
            this.m_outputStream.flush();
        }
        catch (Exception exception) {
            this.trace("FsConnection.writeBytes: Exception caught", exception);
        }
    }

    public void writePacket(FsPacket fsPacket) {
        try {
            FsByteStream fsByteStream = new FsByteStream();
            FsPacket fsPacket2 = fsPacket.build(fsByteStream);
            if (fsPacket2 != null) {
                this.trace("FsConnection.writePacket: build error");
                fsByteStream.clear();
                fsPacket2.build(fsByteStream);
            }
            this.trace("FsConnection.writePacket: " + fsByteStream.getLength() + " bytes written", fsByteStream);
            fsByteStream.writeTo(this.m_outputStream);
            this.m_outputStream.flush();
        }
        catch (Exception exception) {
            this.trace("FsConnection.writePacket: Exception caught", exception);
        }
    }
}

